//########################
//InDesignCS3の連続検索置換ツールです。
//このサンプルでは全角数字を半角数字に検索置換します。
//■通常の検索置換や■正規表現の検索置換をカスタマイズすると好きな設定がつくれます。
//たけうちとおる
//########################


//ダイアログ表示のおまじない
app.scriptPreferences.userInteractionLevel=1699311169;

function find_and_replace(myObject,myCheckSelection){
	//■通常の検索置換■■■■■■■■■■■■■■■■■■■■■■
	//takeFindText(myObject, "検索文字", "置換文字", "検索文字スタイル", "置換文字スタイル","検索段落スタイル", "置換段落スタイル",  myCheckSelection);
	//■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	
	//■正規表現の検索置換■■■■■■■■■■■■■■■■■■■■
	//takeFindGrep(myObject, "検索文字", "置換文字", "検索文字スタイル", "置換文字スタイル","検索段落スタイル", "置換段落スタイル",  myCheckSelection);
	//■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	
	//このような感じで使ってください。
	//■通常の検索置換■■■■■■■■■■■■■■■■■■■■■■
takeFindText(myObject,"１","1", "", "","", "",  myCheckSelection);
takeFindText(myObject,"２","2", "", "","", "",  myCheckSelection);
takeFindText(myObject,"３","3", "", "","", "",  myCheckSelection);
takeFindText(myObject,"４","4", "", "","", "",  myCheckSelection);
takeFindText(myObject,"５","5", "", "","", "",  myCheckSelection);
takeFindText(myObject,"６","6", "", "","", "",  myCheckSelection);
takeFindText(myObject,"７","7", "", "","", "",  myCheckSelection);
takeFindText(myObject,"８","8", "", "","", "",  myCheckSelection);
takeFindText(myObject,"９","9", "", "","", "",  myCheckSelection);
takeFindText(myObject,"０","0", "", "","", "",  myCheckSelection);
	//■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
}

main();

function main(){
	var myObject;
	var myCheckSelection = false;
	if(app.documents.length > 0){
		if(app.selection.length > 0){
			switch(app.selection[0].constructor.name){
				case "InsertionPoint":
				case "Character":
				case "Word":
				case "TextStyleRange":
				case "Line":
				case "Paragraph":
				case "TextColumn":
				case "Text":
					app.scriptPreferences.userInteractionLevel = 1699311169
					//myFindText(myObject, myFindLimit, myFindPreferences, myChangePreferences, myCheckSelection);
					myObject = myDisplayDialog();
					myCheckSelection = myObject[1];
					myObject = myObject[0];
					if(myObject != "None"){
						find_and_replace(myObject, myCheckSelection);
						//myFindChangeByList(myObject, myCheckSelection);
					}
					break;
				default:
					for(var sel = 0;sel < app.selection.length;sel++){
						find_and_replace(app.selection[sel], false);
					}
					//myFindChangeByList(app.documents.item(0), false);
			}
		}
		else{
			//Nothing was selected, so simply search the document.
			find_and_replace(app.documents.item(0), false);
			//myFindChangeByList(app.documents.item(0), false);
		}
		alert("終了しました");
	}
	else{
		alert("No documents are open. Please open a document and try again.");
	}
}
function myDisplayDialog(){
	var myObject;
	var myDialog = app.dialogs.add({name:"検索置換範囲指定"});
	with(myDialog.dialogColumns.add()){
		with(dialogRows.add()){
			with(dialogColumns.add()){
				staticTexts.add({staticLabel:"検索範囲:"});
			}
			var myRangeButtons = radiobuttonGroups.add();
			with(myRangeButtons){
				radiobuttonControls.add({staticLabel:"選択範囲", checkedState:true});
				radiobuttonControls.add({staticLabel:"ストーリー"});
				radiobuttonControls.add({staticLabel:"ドキュメント"});
			}			
		}
	}
	var myResult = myDialog.show();
	if(myResult == true){
		switch(myRangeButtons.selectedButton){
			case 0:
				myObject = app.selection[0];
				myCheckSelection = true;
				break;
			case 1:
				myObject = app.selection[0].parentStory;
				myCheckSelection = false;
				break;
			case 2:
				myObject = app.documents.item(0);
				myCheckSelection = false;
				break;
		}
	}
	else{
		myObject = "None";
	}
	myDialog.destroy();
	return [myObject, myCheckSelection];
}

function takeFindText(myObject, myFindStr, myChangeStr, myFindC_style, myChangeC_style,myFindP_style, myChangeP_style, myCheckSelection){
	//検索置換
	if(myCheckSelection == true){
		//検索対象が選択範囲の時のみtrue
		myObject = app.selection[0];
	}
	app.changeTextPreferences = NothingEnum.nothing;
	app.findTextPreferences = NothingEnum.nothing;
	if(myFindStr != ""){
		app.findTextPreferences.findWhat = myFindStr;
	}
	if(myChangeStr != ""){
		app.changeTextPreferences.changeTo = myChangeStr;
	}
	if(myFindC_style != ""){
		app.findTextPreferences.appliedCharacterStyle = app.activeDocument.characterStyles.item(myFindC_style);
	}
	if(myChangeC_style != ""){
		app.changeTextPreferences.appliedCharacterStyle = app.activeDocument.characterStyles.item(myChangeC_style);
	}
	if(myFindP_style != ""){
		app.findTextPreferences.appliedParagraphStyle = app.activeDocument.paragraphStyles.item(myFindP_style);
	}
	if(myChangeP_style != ""){
		app.changeTextPreferences.appliedParagraphStyle = app.activeDocument.paragraphStyles.item(myChangeP_style);
	}

		var myLoopLimit = 0;
		var myFoundItemsCount = 0;
		var myFoundItemsCountOld = 0;
		outsideloop:
		do{
			try{
			//ここで検索置換している
			myFoundItems = myObject.changeText();
			}catch(msg){
				//文字が短くなってエラーに
				return;
			}
			myLoopLimit ++;
			if(myLoopLimit > 100){
				var myResult = confirm("100回検索置換しました。続けますか？");
				if(myResult == false){
					break outsideloop;
				}
				else{
					myLoopLimit = 0;
				}
			}
			myFoundItemsCount = myFoundItems.length;
			if(myFoundItemsCount == 0){
					myLoopLimit = 1001;
			}else if(myFoundItemsCountOld == myFoundItemsCount){
					//こうしないと置換文字無しでスタイルだけ適応させるときになんどもくりかえしてしまう。
					myLoopLimit = 1001;
			}
			myFoundItemsCountOld = myFoundItemsCount;
		}while(myLoopLimit < 1000);
	
	//Reset the find/change preferences after each search.
	app.changeTextPreferences = NothingEnum.nothing;
	app.findTextPreferences = NothingEnum.nothing;
	if(myCheckSelection == true){
		//検索対象が選択範囲の時のみtrue
		//If myCheckSelection is true, reacquire a reference to the selection each time through the loop.
		//You need to do this because deleting/adding characters has the potential to invalidate the
		//text reference you're using.
		myObject = app.selection[0];
	}
}

function takeFindGrep(myObject, myFindStr, myChangeStr, myFindC_style, myChangeC_style,myFindP_style, myChangeP_style, myCheckSelection){
	//正規表現の検索置換
	app.changeGrepPreferences = NothingEnum.nothing;
	app.findGrepPreferences = NothingEnum.nothing;
	if(myFindStr != ""){
		app.findGrepPreferences.findWhat = myFindStr;
	}
	if(myChangeStr != ""){
		app.changeGrepPreferences.changeTo = myChangeStr;
	}
	if(myFindC_style != ""){
		app.findGrepPreferences.appliedCharacterStyle = app.activeDocument.characterStyles.item(myFindC_style);
	}
	if(myChangeC_style != ""){
		app.changeGrepPreferences.appliedCharacterStyle = app.activeDocument.characterStyles.item(myChangeC_style);
	}
	if(myFindP_style != ""){
		app.findGrepPreferences.appliedParagraphStyle = app.activeDocument.paragraphStyles.item(myFindP_style);
	}
	if(myChangeP_style != ""){
		app.changeGrepPreferences.appliedParagraphStyle = app.activeDocument.paragraphStyles.item(myChangeP_style);
	}
	var myFoundItems = myObject.changeGrep();
	app.changeGrepPreferences = NothingEnum.nothing;
	app.findGrepPreferences = NothingEnum.nothing;
	if(myCheckSelection == true){
		myObject = app.selection[0];
	}
}