//########################
//InDesignCS3にPDFを配置していきます。
//右ページ、左ページ個別にフレームサイズを指定する事ができ、
//さらにPDFの配置時の空きも右ページ、左ページ個別に設定できます。
//ドキュメントを開いて実行してください。
//たけうちとおる
//090722天地左右の比率の間違いを訂正
//########################


//ダイアログ表示のおまじない
app.scriptPreferences.userInteractionLevel=1699311169;
////////下記が初期値になりますので編集してください。//////////
//配置スタートページ
var startpage = 1;
//PDFのスタートページ
var pdfstartpage = 1;
//トリミング　バウンディングボックス=0　アート=1 　トリミング=2　トンボ=3　裁ち落とし=4　メディア=5
var pdfplaceopt = 0;
//左ページ塗りたし天
var l_ten = 3;
//左ページ塗りたし地
var l_chi = 3;
//左ページ塗りたしノド
var l_nodo = 0;
//左ページ塗りたし小口
var l_cogu = 3;
//右ページ塗りたし天
var r_ten = 3;
//右ページ塗りたし地
var r_chi = 3;
//右ページ塗りたしノド
var r_nodo = 0;
//右ページ塗りたし小口
var r_cogu = 3;
//左ページPDFの水平パーセント
var l_myPerW = 100;
//左ページPDFの垂直パーセント
var l_myPerH = 100;
//左ページPDFの空きX方向
var l_akix = -10;
//左ページPDFの空きY方向
var l_akiy = -10;
//右ページPDFの水平パーセント
var r_myPerW = 100;
//右ページPDFの垂直パーセント
var r_myPerH = 100;
//右ページPDFの空きX方向
var r_akix = -10;
//右ページPDFの空きY方向
var r_akiy = -10;

main();
function main(){
	if (app.documents.length == 0){
			alert("ドキュメントを開いて実行してください。");
			return;
	}
	//ダイアログを作成する
	var mypt = 2.83465;
	myDialog = app.dialogs.add({name:"PDFをInDesignに配置します。"});
	with(myDialog){
		with(dialogColumns.add()){
			with(borderPanels.add()){
				with (dialogColumns.add()){
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"配置スタートページ"});
						var d_startpage = integerEditboxes.add({editValue:startpage,minimumValue:1,maximumValue:1000});
						staticTexts.add({staticLabel:"　　PDFのスタートページ"});
						var d_pdfstartpage = integerEditboxes.add({editValue:pdfstartpage,minimumValue:1,maximumValue:1000});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"トリミング"});
						var Listpdfplaceopt = new Array("バウンディングボックス","アート","トリミング","トンボ","裁ち落とし","メディア");
						var d_pdfplaceopt = dropdowns.add({stringList:Listpdfplaceopt, selectedIndex:pdfplaceopt, minWidth:120});
					}
				}
			}
			with(borderPanels.add()){
				with (dialogColumns.add()){
					staticTexts.add({staticLabel:"左ページの塗り足し"});
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"　天"});
						var d_l_ten = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:l_ten *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
						staticTexts.add({staticLabel:"　地"});
						var d_l_chi = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:l_chi*mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"ノド"});
						var d_l_nodo = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:l_nodo *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
						staticTexts.add({staticLabel:"小口"});
						var d_l_cogu = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:l_cogu *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
				}
				with (dialogColumns.add()){
					staticTexts.add({staticLabel:"右ページの塗り足し"});
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"　天"});
						var d_r_ten = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:r_ten *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
						staticTexts.add({staticLabel:"　地"});
						var d_r_chi = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:r_chi *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"ノド"});
						var d_r_nodo = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:r_nodo *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
						staticTexts.add({staticLabel:"小口"});
						var d_r_cogu = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:r_cogu *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
				}
			}
			with(borderPanels.add()){
				with (dialogColumns.add()){
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"左ページPDFの配置方法"});
					}
					/*with (dialogRows.add()){
						staticTexts.add({staticLabel:"配置方法"});
						var Listpdfplaceopt = new Array("比率を指定してセンター", "比率と空き",  "絶対領域指定", "内容をフレームに合わせる", "内容を縦横比率に応じて合わせる（短辺）","フレームに均等に流し込む（長辺）");
						var pdfplaceopt = dropdowns.add({stringList:Listpdfplaceopt, selectedIndex:0, minWidth:120});
					}*/
					with (dialogRows.add()){
						var Listpercent = new Array("100", "90", "80", "70", "60", "50", "40", "30", "20", "10", "0");
						staticTexts.add({staticLabel:"Wの変倍率"});
						var d_l_myPerW = percentComboboxes.add({editValue:l_myPerW,minimumValue:0,maximumValue:1000,stringList:Listpercent});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"Hの変倍率"});
						var d_l_myPerH = percentComboboxes.add({editValue:l_myPerH,minimumValue:0,maximumValue:1000,stringList:Listpercent});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"X方向の空き"});
						var d_l_akix = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:l_akix *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"Y方向の空き"});
						var d_l_akiy = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:l_akiy *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
					/*with (dialogRows.add()){
						staticTexts.add({staticLabel:"絶対領域のX"});s
						var r_ten = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:0 *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
						staticTexts.add({staticLabel:"絶対領域のY"});
						var r_chi = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:0 *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"絶対領域のH"});
						var r_ten = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:0 *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
						staticTexts.add({staticLabel:"絶対領域のW"});
						var r_chi = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:0 *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}*/
				}
				with (dialogColumns.add()){
					staticTexts.add({staticLabel:"　　　　"});
				}
				with (dialogColumns.add()){
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"右ページPDFの配置方法"});
					}
					/*with (dialogRows.add()){
						staticTexts.add({staticLabel:"配置方法"});
						var Listpdfplaceopt = new Array("比率を指定してセンター", "比率と空き",  "絶対領域指定", "内容をフレームに合わせる", "内容を縦横比率に応じて合わせる（短辺）","フレームに均等に流し込む（長辺）");
						var pdfplaceopt = dropdowns.add({stringList:Listpdfplaceopt, selectedIndex:0, minWidth:120});
					}*/
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"Wの変倍率"});
						var d_r_myPerW = percentComboboxes.add({editValue:r_myPerW,minimumValue:0,maximumValue:1000,stringList:Listpercent});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"Hの変倍率"});
						var d_r_myPerH = percentComboboxes.add({editValue:r_myPerH,minimumValue:0,maximumValue:1000,stringList:Listpercent});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"X方向の空き"});
						var d_r_akix = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:r_akix *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"Y方向の空き"});
						var d_r_akiy = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:r_akiy *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
					/*with (dialogRows.add()){
						staticTexts.add({staticLabel:"絶対領域のX"});
						var r_ten = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:0 *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
						staticTexts.add({staticLabel:"絶対領域のY"});
						var r_chi = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:0 *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}
					with (dialogRows.add()){
						staticTexts.add({staticLabel:"絶対領域のH"});
						var r_ten = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:0 *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
						staticTexts.add({staticLabel:"絶対領域のW"});
						var r_chi = measurementEditboxes.add({editUnits:MeasurementUnits.millimeters, editValue:0 *mypt,minimumValue:-1000*mypt,maximumValue:1000*mypt});
					}*/
				}
			}
			staticTexts.add({staticLabel:"(C)2009 Toru Takeuchi このスクリプトはフリーウェアです。"});
		}
	}
	var myReturn = myDialog.show();
	//ここから処理を行う
	if (myReturn == true){
		startpage = d_startpage.editValue;
		pdfstartpage = d_pdfstartpage.editValue;
		//トリミング　バウンディングボックス=0　アート=1 　トリミング=2　トンボ=3　裁ち落とし=4　メディア=5
		//editContents
		pdfplaceopt = d_pdfplaceopt.selectedIndex;
		l_ten = d_l_ten.editValue/mypt;
		l_chi = d_l_chi.editValue/mypt;
		l_nodo = d_l_nodo.editValue/mypt;
		l_cogu = d_l_cogu.editValue/mypt;
		r_ten = d_r_ten.editValue/mypt;
		r_chi = d_r_chi.editValue/mypt;
		r_nodo = d_r_nodo.editValue/mypt;
		r_cogu = d_r_cogu.editValue/mypt;
//
		l_myPerW = d_l_myPerW.editValue;
		l_myPerH = d_l_myPerH.editValue;
		l_akix = d_l_akix.editValue/mypt;
		l_akiy = d_l_akiy.editValue/mypt;
		r_myPerW = d_r_myPerW.editValue;
		r_myPerH = d_r_myPerH.editValue;
		r_akix = d_r_akix.editValue/mypt;
		r_akiy = d_r_akiy.editValue/mypt;
		myDialog.destroy();
		indd_select_pdf();
	}
	else{
		myDialog.destroy();
	}
}

function indd_select_pdf(){
	if (app.documents.length != 0){
		var selFile = File.openDialog("PDFファイルを選択してください");
		//トリミング　バウンディングボックス=0　アート=1 　トリミング=2　トンボ=3　裁ち落とし=4　メディア=5
		if(pdfplaceopt == 0){
			app.pdfPlacePreferences.pdfCrop = PDFCrop.CROP_CONTENT;	//1131573315	バウンディングボックス
		}else if(pdfplaceopt == 1){
			app.pdfPlacePreferences.pdfCrop = PDFCrop.CROP_ART;//アート
		}else if(pdfplaceopt == 2){
			app.pdfPlacePreferences.pdfCrop = PDFCrop.CROP_PDF;//	1131573328	トリミング
		}else if(pdfplaceopt == 3){
			app.pdfPlacePreferences.pdfCrop = PDFCrop.CROP_TRIM;//	1131573332	トンボ
		}else if(pdfplaceopt == 4){
			app.pdfPlacePreferences.pdfCrop = PDFCrop.CROP_BLEED;//	1131573314	裁ち落とし
		}else if(pdfplaceopt == 5){
			app.pdfPlacePreferences.pdfCrop = PDFCrop.CROP_MEDIA;//	1131573325	メディア
		}
		var loopflg = true;
		var placepage = startpage;
		var pdfpage = pdfstartpage;
		while (loopflg){
			loopflg = placepdf(selFile,placepage,pdfpage);
			placepage++;
			pdfpage++;
		}
	}
}
function placepdf(selFile,placepage,pdfpage){
	app.pdfPlacePreferences.pageNumber = pdfpage;
	if(app.activeDocument.pages.length < placepage){
		var pageObj = app.activeDocument.pages.add();
	}else{
		var pageObj = app.activeDocument.pages[placepage-1];
	}
	var rectObj = pageObj.rectangles.add();
	rectObj.strokeWeight = 0;
	var rectbounds = pageObj.bounds;
	if(pageObj.side == PageSideOptions.rightHand){
		//[Y1,X1,Y2,X2]//(top,left,bottom,right)
		rectbounds[0]=rectbounds[0]-r_ten;
		rectbounds[1]=rectbounds[1]-r_nodo;
		rectbounds[2]=rectbounds[2]+r_chi;
		rectbounds[3]=rectbounds[3]+r_cogu;
	}else{
		//[Y1,X1,Y2,X2]
		rectbounds[0]=rectbounds[0]-l_ten;
		rectbounds[1]=rectbounds[1]-l_cogu;
		rectbounds[2]=rectbounds[2]+l_chi;
		rectbounds[3]=rectbounds[3]+l_nodo;
	}
	rectObj.geometricBounds = rectbounds;
	var pdfobj = rectObj.place(selFile);
	if(pageObj.side == PageSideOptions.rightHand){
		rectObj.allGraphics[0].verticalScale = r_myPerH;
		rectObj.allGraphics[0].horizontalScale = r_myPerW;
	}else{
		rectObj.allGraphics[0].verticalScale = l_myPerH;
		rectObj.allGraphics[0].horizontalScale = l_myPerW;
	}
	var rectbounds = rectObj.allGraphics[0].geometricBounds;
	var myH = rectbounds[2]-rectbounds[0];
	var myW = rectbounds[3]-rectbounds[1];
	if(pageObj.side == PageSideOptions.rightHand){
		rectbounds[0]=rectbounds[0]+r_akiy;
		rectbounds[1]=rectbounds[1]+r_akix;
		rectbounds[2]=rectbounds[0]+myH;
		rectbounds[3]=rectbounds[1]+ myW;
	}else{
		rectbounds[0]=rectbounds[0]+l_akiy;
		rectbounds[1]=rectbounds[1]+l_akix;
		rectbounds[2]=rectbounds[0]+myH;
		rectbounds[3]=rectbounds[1]+ myW;
	}
	rectObj.allGraphics[0].geometricBounds = rectbounds;
	var placedpdfpage = rectObj.allGraphics[0].pdfAttributes.pageNumber;
	if(placedpdfpage != pdfpage){
		pageObj.remove();
		return false;
	}
	return true;
}