//########################
//選択された文字をルビにします。
//[誕生日/たんじょうび]
//を選択すると誕生日にグループルビが付きます。
//[誕生日/たん.じょう.び]
//を選択すると誕生日にモノルビが付きます。
//たけうちとおる
//########################

var myDocu=app.activeDocument;
var selList=myDocu.selection;
var itemCount=selList.length;
if(itemCount==0){
	alert("テキストフレームを選択ツールで選択してください。");
}
for(var item_index=0;item_index < itemCount;item_index++){
	var c_name = selList[item_index].constructor.name;
		//case "InsertionPoint":
		//case "Character":
		//case "Word":
		//case "TextStyleRange":
		//case "Line":
		//case "Paragraph":
		//case "TextColumn":
		//case "Text":
	var mySelLength = selList[item_index].characters.length;
	for(var c = mySelLength-1;c > -1; c--){
		var myCha = selList[item_index].characters[c].contents;
		if(myCha == "]"){var myEndCha = c;}
		else if(myCha == "["){
			var myStartCha = c;
			if(c_name== "TextFrame"){
				setRuby(selList[item_index],myStartCha+1,myEndCha-1);
			}else if(c_name== "Character" || c_name== "Word" || c_name== "TextStyleRange" || c_name== "Line" || c_name== "Paragraph" || c_name== "TextColumn" || c_name== "Text"){
				setRuby_text(selList,myStartCha+1,myEndCha-1);
				selList=myDocu.selection;
			}
		}
	}
	//alert(selList[item_index].constructor.name);
}
function setRuby_text(selList,myStartCha,myEndCha){
    var myStr = selList[0].characters.itemByRange(myStartCha, myEndCha).contents;
    var strAry = myStr[0].split("/");
    var kanji = strAry[0];
    var kanjiCount = kanji.length;
    var kana = strAry[1];
    var kanaAry = kana.split(".");
    var rubyCount = kanaAry.length;
    if(rubyCount == 0){
	//alert("「誕生日/たん,じょう,び」のようにしてください。");
    }else if(rubyCount == 1){
        selList[0].characters.itemByRange(myStartCha, myStartCha+kanjiCount-1).rubyString = kana;
        selList[0].characters.itemByRange(myStartCha, myStartCha+kanjiCount-1).rubyType = RubyTypes.GROUP_RUBY;
        selList[0].characters.itemByRange(myStartCha, myStartCha+kanjiCount-1).rubyFlag = true;
        selList[0].characters.itemByRange(myStartCha+kanjiCount, myEndCha+1).contents = "";
        selList=myDocu.selection;
        selList[0].characters[myStartCha-1].contents="";
    }else{
        for(var i = 0; i < kanjiCount;i++){
            selList[0].characters[myStartCha+i].rubyString = kanaAry[i];
            selList[0].characters[myStartCha+i].rubyFlag = true;
        }
        selList[0].characters.itemByRange(myStartCha+kanjiCount, myEndCha+1).contents = "";
        selList=myDocu.selection;
        selList[0].characters[myStartCha-1].contents="";
    }
}

function setRuby(selobj,myStartCha,myEndCha){
    var myStr = selobj.characters.itemByRange(myStartCha, myEndCha).contents;
    var strAry = myStr[0].split("/");
    var kanji = strAry[0];
    var kanjiCount = kanji.length;
    var kana = strAry[1];
    var kanaAry = kana.split(".");
    var rubyCount = kanaAry.length;
    if(rubyCount == 0){
	//alert("「誕生日/たん,じょう,び」のようにしてください。");
    }else if(rubyCount == 1){
		//グループルビ
        selobj.characters.itemByRange(myStartCha, myStartCha+kanjiCount-1).rubyString = kana;
        selobj.characters.itemByRange(myStartCha, myStartCha+kanjiCount-1).rubyType = RubyTypes.GROUP_RUBY;
        selobj.characters.itemByRange(myStartCha, myStartCha+kanjiCount-1).rubyFlag = true;
        selobj.characters.itemByRange(myStartCha+kanjiCount, myEndCha+1).contents = "";
        //selobj=myDocu.selection;
        selobj.characters[myStartCha-1].contents="";
    }else{
		//モノルビ
        for(var i = 0; i < kanjiCount;i++){
            selobj.characters[myStartCha+i].rubyString = kanaAry[i];
            selobj.characters[myStartCha+i].rubyFlag = true;
        }
        selobj.characters.itemByRange(myStartCha+kanjiCount, myEndCha+1).contents = "";
        //selList=myDocu.selection;
        selobj.characters[myStartCha-1].contents="";
    }
}